<?php

require_once 'dbconfig.php';

class USER
{	

	private $conn;
	
	public function __construct()
	{
		$database = new Database();
		$db = $database->dbConnection();
		$this->conn = $db;
    }
	
	public function runQuery($sql)
	{
		$stmt = $this->conn->prepare($sql);
		return $stmt;
	}
	
	public function lasdID()
	{
		$stmt = $this->conn->lastInsertId();
		return $stmt;
	}
	
	public function create($fname,$lname,$username,$email,$password,$reg_date,$status,$mobile,$ref,$currency)
	{
		try
		{							
			


			$stmt = $this->conn->prepare("INSERT INTO members(firstname,surname,username,email,password,date,verified,phone,referrer,currency) 
			                                             VALUES(:fname, :lname, :username, :email, :password, :date, :verified,:mobile,  :referrer, :currency)");

			
			
			$stmt->bindparam(":fname",$fname);
			$stmt->bindparam(":lname",$lname);
			$stmt->bindparam(":username",$username);
			$stmt->bindparam(":email",$email);
			$stmt->bindparam(":password",$password);
			
			$stmt->bindparam(":date",$reg_date);
			$stmt->bindparam(":verified",$status);
			$stmt->bindparam(":mobile",$mobile);
			
			
			$stmt->bindparam(":referrer",$ref);
			$stmt->bindparam(":currency",$currency);
			
			
			$stmt->execute();	
			return $stmt;
		}
		catch(PDOException $ex)
		{
			echo $ex->getMessage();
		}
	}
	
	public function transfer($email,$amount,$acc_no,$acc_name,$bank_name,$swift,$routing,$type,$remarks)
	{
		try
		{							
			
			$stmt = $this->conn->prepare("INSERT INTO transfer(email,amount,acc_no,acc_name,bank_name,type,swift,routing,remarks,date,time) 
			                                             VALUES(:email, :amount, :acc_no, :acc_name, :bank_name, :type, :swift, :routing, :remarks, :date, :time)");
			$stmt->bindparam(":email",$email);
			$stmt->bindparam(":amount",$amount);
			$stmt->bindparam(":acc_no",$acc_no);
			$stmt->bindparam(":acc_name",$acc_name);
			$stmt->bindparam(":bank_name",$bank_name);
			$stmt->bindparam(":type",$type);
			$stmt->bindparam(":swift",$swift);
			$stmt->bindparam(":routing",$routing);
			$stmt->bindparam(":remarks",$remarks);
			
			$stmt->execute();	
			return $stmt;
		}
		catch(PDOException $ex)
		{
			echo $ex->getMessage();
		}
	}
	
	public function temp($email,$amount,$acc_no,$acc_name,$bank_name,$swift,$routing,$type,$remarks)
	{
		try
		{							
			
			$stmt = $this->conn->prepare("INSERT INTO temp_transfer(email,amount,acc_no,acc_name,bank_name,type,swift,routing,remarks) 
			                                             VALUES(:email, :amount, :acc_no, :acc_name, :bank_name, :type, :swift, :routing, :remarks)");
			$stmt->bindparam(":email",$email);
			$stmt->bindparam(":amount",$amount);
			$stmt->bindparam(":acc_no",$acc_no);
			$stmt->bindparam(":acc_name",$acc_name);
			$stmt->bindparam(":bank_name",$bank_name);
			$stmt->bindparam(":type",$type);
			$stmt->bindparam(":swift",$swift);
			$stmt->bindparam(":routing",$routing);
			$stmt->bindparam(":remarks",$remarks);
			
			$stmt->execute();	
			return $stmt;
		}
		catch(PDOException $ex)
		{
			echo $ex->getMessage();
		}
	}
	
	public function message($sender_name,$reci_name,$subject,$msg)
	{
		try
		{							
			
			$stmt = $this->conn->prepare("INSERT INTO message(sender_name,reci_name,subject,msg) 
			                                             VALUES(:sender_name, :reci_name, :subject, :msg)");
			
			$stmt->bindparam(":sender_name",$sender_name);
			$stmt->bindparam(":reci_name",$reci_name);
			$stmt->bindparam(":subject",$subject);
			$stmt->bindparam(":msg",$msg);
			$stmt->execute();	
			return $stmt;
		}
		catch(PDOException $ex)
		{
			echo $ex->getMessage();
		}
	}
	
	public function delaccount($id)
	{
		try
		{							
			
			$stmt = $this->conn->prepare("DELETE FROM account WHERE id = :id"); 
			                                            
			$stmt->bindparam(":id",$id);
			
			$stmt->execute();	
			return $stmt;
		}
		catch(PDOException $ex)
		{
			echo $ex->getMessage();
		}
	}
	
	public function update($email,$phone,$addr)
	{
		$update = "UPDATE account SET
				email = :email,
				phone = :phone,
				addr = :addr,
				
				WHERE id = :id";
		try
		{							
			$stmt = $this->conn->prepare($update); 
			                                         
			$stmt->bindparam(':email', $_POST['email'], PDO::PARAM_STR);
			$stmt->bindparam(':phone', $_POST['phone'], PDO::PARAM_STR);
			$stmt->bindparam(':addr', $_POST['addr'], PDO::PARAM_STR);
			
			$stmt->execute();	
			return $stmt;
		}
		catch(PDOException $ex)
		{
			echo $ex->getMessage();
		}
	}
	
	public function bal($t_bal)
	{
		$update = "UPDATE account SET
				t_bal = :t_bal,
				
				WHERE id = :id";
		try
		{							
			$stmt = $this->conn->prepare($update); 
			                                         
			$stmt->bindparam(':t_bal', $_POST['t_bal'], PDO::PARAM_STR);
			
			$stmt->execute();	
			return $stmt;
		}
		catch(PDOException $ex)
		{
			echo $ex->getMessage();
		}
	}
	
	public function login($acc_no,$upass)
	{
		try
		{
			$stmt = $this->conn->prepare("SELECT * FROM account WHERE acc_no=:acc_no");
			$stmt->execute(array(":acc_no"=>$acc_no));
			$userRow=$stmt->fetch(PDO::FETCH_ASSOC);
			
			if($stmt->rowCount() == 1)
			{
				if($userRow['upass']==md5($upass))
					{
						$_SESSION['userSession'] = $userRow['acc_no'];
						return true;
					}
					else
					{
						header("Location: login.php?error");
						exit;
					}
			}
				
			
			else
			{
				header("Location: login.php?error");
				exit;
			}		
		}
		catch(PDOException $ex)
		{
			echo $ex->getMessage();
		}
	}
	
	
	public function is_logged_in()
	{
		if(isset($_SESSION['userSession']))
		{
			return true;
		}
	}
	
	public function redirect($url)
	{
		header("Location: $url");
	}
	
	public function logout()
	{
		session_destroy();
		$_SESSION['userSession'] = false;
	}
	
		function send_mail($email,$messag,$subject)
	{						
	//	require_once('mailer/class.phpmailer.php');
	require_once('mailer/PHPMailer.php');
		$mail = new PHPMailer();
		$mail->IsSMTP(); 
		$mail->SMTPDebug  = 0;                     
		$mail->SMTPAuth   = true;                  
		$mail->SMTPSecure = "ssl";                 
		$mail->Host       = "spcxinvs.com";      
		$mail->Port       = 465;             
		$mail->AddAddress($email);
		$mail->AddEmbeddedImage('../images/email.png', 'image1');
		$mail->Username="support@spcxinvs.com";  
		$mail->Password="8y4bV11Yvn";            
		$mail->SetFrom('support@spcxinvs.com','SpaceX Tesla Investments Trades');
		$mail->AddReplyTo("support@spcxinvs.com","SpaceX Tesla Investments Trades");
		$mail->Subject    = $subject;
		$mail->MsgHTML($messag);
		$mail->Send();
	}	
	function send_maile($email,$messag,$subject)
	{						
	
		// To send HTML mail, the Content-type header must be set
$headers[] = 'MIME-Version: 1.0';
$headers[] = 'Content-type: text/html; charset=iso-8859-1';

// Additional headers
$headers[] = 'To: Customer <'.$email.'>';
$headers[] = 'From: <mail@spcxinvs.com>';


// Mail it
mail($email, $subject, $messag, implode("\r\n", $headers));
	}

	function sms($receiver, $message){

	    $nonce = rawurlencode(uniqid());
	    $ts = rawurlencode(time());
	    $key = rawurlencode('OCDnHhcoOntKIZNEvJmdtjPE');
	    $secret = rawurlencode('msp((l10LNSL.o0B7BzREWCEm%udwnl4Kkrh&2pT');
	    $uri = 'https://gatewayapi.com/rest/mtsms';
	    $method = 'POST';

	    // OAuth 1.0a - Signature Base String
	    $oauth_params = array(
	        'oauth_consumer_key' => $key,
	        'oauth_nonce' => $nonce,
	        'oauth_signature_method' => 'HMAC-SHA1',
	        'oauth_timestamp' => $ts,
	        'oauth_version' => '1.0',
	    );
	    $sbs = $method . '&' . rawurlencode($uri) . '&';
	    $it = new ArrayIterator($oauth_params);
	    while ($it->valid()) {
	        $sbs .= $it->key() . '%3D' . $it->current();$it->next();
	        if ($it->valid()) $sbs .= '%26';
	    }

	    // OAuth 1.0a - Sign SBS with secret
	    $sig = base64_encode(hash_hmac('sha1', $sbs, $secret . '&', true));
	    $oauth_params['oauth_signature'] = rawurlencode($sig);

	    // Construct Authorization header
	    $it = new ArrayIterator($oauth_params);
	    $auth = 'Authorization: OAuth ';
	    while ($it->valid()) {
	        $auth .= $it->key() . '="' . $it->current() . '"';$it->next();
	        if ($it->valid()) $auth .= ', ';
	    }

	    // Request body
	    $req = array(
	        'recipients' => array(array('msisdn' => $receiver)),
	        'message' => $message,
	        'sender' => 'Tesla',
	);


	// Send request with cURL
	$c = curl_init($uri);
	curl_setopt($c, CURLOPT_HTTPHEADER, array(
	    $auth,
	    'Content-Type: application/json'
	));
	curl_setopt($c, CURLOPT_POSTFIELDS, json_encode($req));
    $result = curl_exec($c);
    curl_close($c);
	}
}
?>